<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="pageHelp" value="${pageFlow.summaryHelpURI}" />
<c:set var="printerFriendlyPageAction" value="viewPrinterFriendlyUnresolvedStatusSummary" />
<c:set var="showUpdatingMsg" value="true" />

<%@ include file="pageHeader.jspf" %>
<br/>
<%@ include file="pastDueMessage.jsp" %>

<%@ include file="wellnessReminderUnresolvedSummaryDescription.jspf" %>
<p>	
   <display:table id="${pageFlow.tableUID}" 
	        uid="${pageFlow.tableUID}" 
		    name="${pageFlow.wellnessReminders}"
	        pagesize="10" 
	        sort="list"  
	        defaultsort="${pageFlow.defaultSortProperty}"
	        defaultorder="${pageFlow.defaultSortOrder.name}"        
	        requestURI="handleUnresolvedPagingAndSorting.do">
	    <display:setProperty name="custom.sort.class" 
            value="${pageFlow.sortClassName}" />
    	<display:setProperty name="basic.msg.empty_list_row"
	    	value="There are currently no Wellness Reminders available" />

   	    <display:column sortable="true" sortProperty="dueDate" title="Due Date"
   	        style="padding: 3px 3px 4px 3px">
	        <c:if test="${WellnessReminder.showSymbol}">
        	   <img src="<%=request.getContextPath()%>/resources/images/icon_error-critical.gif"
    	    	    title="Alert Icon" height="15" width="15" alt="Alert Icon"/>
			</c:if>
			${WellnessReminder.dueDate}
        </display:column>  
		<display:column property="subject" sortable="true" title="Wellness Reminder" 
		    href="viewDetails.do?fromPage=Unresolved" paramId="id" paramProperty="id"/>
		<display:column property="dateLastDone" sortable="true" 
		    title="Last Completed"/>    
		<display:column property="location" sortable="true" title="Location"/>
	</display:table>
		
</p>

 	<div class="mhv-button-container-align-right">
		<netui:anchor action="viewCompletedStatusSummary" styleClass="mhv-input-button">
			Go to Completed Wellness Reminders
		</netui:anchor>
	</div>
	
 	<div class="mhv-button-container-align-left">
		<netui:anchor action="viewPreferences" styleClass="mhv-input-button">
		  <netui:parameter name="fromPage" value="Unresolved"/>
			Go to Reminders Preferences
		</netui:anchor>
	</div>
<br/>
<%@ include file="goldStandardText.jspf"%>
<br/>
<%@ include file="../../common/pageFooter.jspf" %>